<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('admin.topmenu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="main-panel">
        <div class="content">
            <div class="page-inner">
                <!-- Page Heading -->
                <div class="d-sm-flex align-items-center justify-content-between mb-4">
                    <div>
                        <h1 class="h3 mb-0 text-<?php echo e($text); ?>">
                            <i class="fas fa-edit text-primary"></i> Edit Celebrity Booking
                        </h1>
                        <p class="mb-0 text-muted">Reference: <strong><?php echo e($booking->booking_reference); ?></strong></p>
                    </div>
                    <div class="d-flex gap-2">
                        <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-secondary btn-sm shadow-sm">
                            <i class="fas fa-home fa-sm text-white-50"></i> Back to Home
                        </a>
                        <a href="<?php echo e(route('admin.bookings.show', $booking->id)); ?>" class="btn btn-info btn-sm shadow-sm">
                            <i class="fas fa-eye fa-sm text-white-50"></i> View Details
                        </a>
                        <a href="<?php echo e(route('admin.bookings.index')); ?>" class="btn btn-secondary btn-sm shadow-sm">
                            <i class="fas fa-arrow-left fa-sm text-white-50"></i> Back to List
                        </a>
                        <div class="dropdown">
                            <button class="btn btn-outline-primary btn-sm dropdown-toggle" type="button" data-toggle="dropdown">
                                <i class="fas fa-cog"></i> Actions
                            </button>
                            <div class="dropdown-menu dropdown-menu-right">
                                <a class="dropdown-item" href="#" onclick="previewChanges()">
                                    <i class="fas fa-eye fa-sm fa-fw mr-2"></i> Preview Changes
                                </a>
                                <a class="dropdown-item" href="#" onclick="resetForm()">
                                    <i class="fas fa-undo fa-sm fa-fw mr-2"></i> Reset Form
                                </a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="#" onclick="printBooking()">
                                    <i class="fas fa-print fa-sm fa-fw mr-2"></i> Print Form
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = $__env->getContainer()->make(Illuminate\View\AnonymousComponent::class, ['view' => 'components.danger-alert','data' => []]); ?>
<?php $component->withName('danger-alert'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?>

                <!-- Status Messages -->
                <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show shadow-sm" role="alert">
                    <i class="fas fa-check-circle"></i> <?php echo e(session('success')); ?>

                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <?php endif; ?>

                <?php if(session('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show shadow-sm" role="alert">
                    <i class="fas fa-exclamation-triangle"></i> <?php echo e(session('error')); ?>

                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                <div class="alert alert-danger alert-dismissible fade show shadow-sm" role="alert">
                    <i class="fas fa-exclamation-triangle"></i> Please fix the following errors:
                    <ul class="mb-0 mt-2">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <?php endif; ?>

                <!-- Overview Status Cards -->
                <div class="row mb-4">
                    <!-- Booking Status Card -->
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card border-left-<?php echo e($booking->booking_status == 'pending' ? 'warning' :
                            ($booking->booking_status == 'approved' ? 'primary' :
                            ($booking->booking_status == 'completed' ? 'success' :
                            ($booking->booking_status == 'cancelled' ? 'danger' : 'secondary')))); ?> shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-<?php echo e($booking->booking_status == 'pending' ? 'warning' :
                                            ($booking->booking_status == 'approved' ? 'primary' :
                                            ($booking->booking_status == 'completed' ? 'success' :
                                            ($booking->booking_status == 'cancelled' ? 'danger' : 'secondary')))); ?> text-uppercase mb-1">Booking Status</div>
                                        <div class="h6 mb-0 font-weight-bold text-<?php echo e($text); ?>">
                                            <?php echo e(ucfirst($booking->booking_status)); ?>

                                        </div>
                                        <small class="text-muted"><?php echo e($booking->created_at->format('M j, Y')); ?></small>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-flag fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Payment Status Card -->
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card border-left-<?php echo e($booking->payment_status == 'pending' ? 'warning' :
                            ($booking->payment_status == 'paid' ? 'success' : 'danger')); ?> shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-<?php echo e($booking->payment_status == 'pending' ? 'warning' :
                                            ($booking->payment_status == 'paid' ? 'success' : 'danger')); ?> text-uppercase mb-1">Payment Status</div>
                                        <div class="h6 mb-0 font-weight-bold text-<?php echo e($text); ?>">
                                            <?php echo e(ucfirst($booking->payment_status)); ?>

                                        </div>
                                        <?php if($booking->payment_date): ?>
                                            <small class="text-muted"><?php echo e($booking->payment_date->format('M j, Y')); ?></small>
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-credit-card fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Total Amount Card -->
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card border-left-success shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Total Amount</div>
                                        <div class="h5 mb-0 font-weight-bold text-<?php echo e($text); ?>">
                                            $<?php echo e(number_format($booking->total_amount, 2)); ?>

                                        </div>
                                        <?php if($booking->booking_fee > 0 && $booking->service_fee > 0): ?>
                                            <small class="text-muted">Fee: $<?php echo e(number_format($booking->booking_fee, 2)); ?> + Service: $<?php echo e(number_format($booking->service_fee, 2)); ?></small>
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-dollar-sign fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Booking Type Card -->
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card border-left-info shadow h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Booking Type</div>
                                        <div class="h6 mb-0 font-weight-bold text-<?php echo e($text); ?>">
                                            <?php echo e(ucfirst(str_replace('_', ' ', $booking->booking_type))); ?>

                                        </div>
                                        <small class="text-muted">
                                            <?php if($booking->user_id): ?>
                                                Registered User
                                            <?php else: ?>
                                                Guest Booking
                                            <?php endif; ?>
                                        </small>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-tag fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Edit Form -->
                <form action="<?php echo e(route('admin.bookings.updateStatus', $booking->id)); ?>" method="POST" class="needs-validation" novalidate>
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div class="row">
                        <!-- Main Form Content -->
                        <div class="col-lg-8">
                            <!-- Customer Information -->
                            <div class="card shadow mb-4">
                                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                    <h6 class="m-0 font-weight-bold text-primary">
                                        <i class="fas fa-user"></i> Customer Information
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="full_name" class="form-label font-weight-bold">
                                                    <i class="fas fa-id-card text-primary"></i> Full Name <span class="text-danger">*</span>
                                                </label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['full_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                       name="full_name" id="full_name" value="<?php echo e(old('full_name', $booking->full_name)); ?>" required>
                                                <?php $__errorArgs = ['full_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="email" class="form-label font-weight-bold">
                                                    <i class="fas fa-envelope text-info"></i> Email Address <span class="text-danger">*</span>
                                                </label>
                                                <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                       name="email" id="email" value="<?php echo e(old('email', $booking->email)); ?>" required>
                                                <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="phone" class="form-label font-weight-bold">
                                                    <i class="fas fa-phone text-success"></i> Phone Number <span class="text-danger">*</span>
                                                </label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                       name="phone" id="phone" value="<?php echo e(old('phone', $booking->phone)); ?>" required>
                                                <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="gender" class="form-label font-weight-bold">
                                                    <i class="fas fa-venus-mars text-secondary"></i> Gender
                                                </label>
                                                <select class="form-control <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="gender" id="gender">
                                                    <option value="">Select Gender</option>
                                                    <option value="male" <?php echo e(old('gender', $booking->gender) == 'male' ? 'selected' : ''); ?>>Male</option>
                                                    <option value="female" <?php echo e(old('gender', $booking->gender) == 'female' ? 'selected' : ''); ?>>Female</option>
                                                    <option value="other" <?php echo e(old('gender', $booking->gender) == 'other' ? 'selected' : ''); ?>>Other</option>
                                                </select>
                                                <?php $__errorArgs = ['gender'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="address" class="form-label font-weight-bold">
                                            <i class="fas fa-map-marker-alt text-warning"></i> Address
                                        </label>
                                        <textarea class="form-control <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                  name="address" id="address" rows="3"><?php echo e(old('address', $booking->address)); ?></textarea>
                                        <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>
                            <!-- Event Information -->
                            <div class="card shadow mb-4">
                                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                                    <h6 class="m-0 font-weight-bold text-primary">
                                        <i class="fas fa-calendar-alt"></i> Event Information
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="celebrity_id" class="form-label font-weight-bold">
                                                    <i class="fas fa-star text-warning"></i> Celebrity <span class="text-danger">*</span>
                                                </label>
                                                <select class="form-control select2 <?php $__errorArgs = ['celebrity_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        name="celebrity_id" id="celebrity_id" required>
                                                    <option value="">Select Celebrity</option>
                                                    <?php $__currentLoopData = $celebrities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $celebrity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($celebrity->id); ?>" <?php echo e(old('celebrity_id', $booking->celebrity_id) == $celebrity->id ? 'selected' : ''); ?>>
                                                            <?php echo e($celebrity->name); ?> - <?php echo e($celebrity->known_for); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <?php $__errorArgs = ['celebrity_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="booking_type" class="form-label font-weight-bold">
                                                    <i class="fas fa-tag text-info"></i> Booking Type <span class="text-danger">*</span>
                                                </label>
                                                <select class="form-control <?php $__errorArgs = ['booking_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                        name="booking_type" id="booking_type" required>
                                                    <option value="booking" <?php echo e(old('booking_type', $booking->booking_type) == 'booking' ? 'selected' : ''); ?>>Standard Booking</option>
                                                    <option value="donation" <?php echo e(old('booking_type', $booking->booking_type) == 'donation' ? 'selected' : ''); ?>>Donation</option>
                                                    <option value="fan_card" <?php echo e(old('booking_type', $booking->booking_type) == 'fan_card' ? 'selected' : ''); ?>>VIP Fan Card</option>
                                                </select>
                                                <?php $__errorArgs = ['booking_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="event_type" class="form-label font-weight-bold">
                                                    <i class="fas fa-clipboard-list text-primary"></i> Event Type <span class="text-danger">*</span>
                                                </label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['event_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                       name="event_type" id="event_type" value="<?php echo e(old('event_type', $booking->event_type)); ?>" required>
                                                <?php $__errorArgs = ['event_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="event_location" class="form-label font-weight-bold">
                                                    <i class="fas fa-map-pin text-danger"></i> Event Location <span class="text-danger">*</span>
                                                </label>
                                                <input type="text" class="form-control <?php $__errorArgs = ['event_location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                       name="event_location" id="event_location" value="<?php echo e(old('event_location', $booking->event_location)); ?>" required>
                                                <?php $__errorArgs = ['event_location'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="event_date" class="form-label font-weight-bold">
                                                    <i class="fas fa-calendar text-info"></i> Event Date <span class="text-danger">*</span>
                                                </label>
                                                <input type="date" class="form-control <?php $__errorArgs = ['event_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                       name="event_date" id="event_date" value="<?php echo e(old('event_date', $booking->event_date->format('Y-m-d'))); ?>" required>
                                                <?php $__errorArgs = ['event_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="event_time" class="form-label font-weight-bold">
                                                    <i class="fas fa-clock text-warning"></i> Event Time <span class="text-danger">*</span>
                                                </label>
                                                <input type="time" class="form-control <?php $__errorArgs = ['event_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                       name="event_time" id="event_time" value="<?php echo e(old('event_time', \Carbon\Carbon::parse($booking->event_time)->format('H:i'))); ?>" required>
                                                <?php $__errorArgs = ['event_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="duration" class="form-label font-weight-bold">
                                                    <i class="fas fa-hourglass-half text-secondary"></i> Duration (minutes) <span class="text-danger">*</span>
                                                </label>
                                                <input type="number" class="form-control <?php $__errorArgs = ['duration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                       name="duration" id="duration" value="<?php echo e(old('duration', $booking->duration)); ?>" min="15" max="480" required>
                                                <?php $__errorArgs = ['duration'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if($booking->special_requests): ?>
                                    <div class="form-group">
                                        <label for="special_requests" class="form-label font-weight-bold">
                                            <i class="fas fa-star text-warning"></i> Special Requests
                                        </label>
                                        <textarea class="form-control <?php $__errorArgs = ['special_requests'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                  name="special_requests" id="special_requests" rows="3"><?php echo e(old('special_requests', $booking->special_requests)); ?></textarea>
                                        <?php $__errorArgs = ['special_requests'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- Sidebar -->
                        <div class="col-lg-4">
                            <!-- Payment Information -->
                            <div class="card shadow mb-4">
                                <div class="card-header py-3">
                                    <h6 class="m-0 font-weight-bold text-primary">
                                        <i class="fas fa-credit-card"></i> Payment Information
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="form-group">
                                        <label for="booking_fee" class="form-label font-weight-bold">
                                            Booking Fee <span class="text-danger">*</span>
                                        </label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">$</span>
                                            </div>
                                            <input type="number" class="form-control <?php $__errorArgs = ['booking_fee'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                   name="booking_fee" id="booking_fee" step="0.01" min="0"
                                                   value="<?php echo e(old('booking_fee', $booking->booking_fee)); ?>" required>
                                            <?php $__errorArgs = ['booking_fee'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label for="service_fee" class="form-label font-weight-bold">
                                            Service Fee
                                        </label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">$</span>
                                            </div>
                                            <input type="number" class="form-control <?php $__errorArgs = ['service_fee'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                   name="service_fee" id="service_fee" step="0.01" min="0"
                                                   value="<?php echo e(old('service_fee', $booking->service_fee)); ?>" required>
                                            <?php $__errorArgs = ['service_fee'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                    <div class="form-group">
                                        <label for="total_amount" class="form-label font-weight-bold">
                                            Total Amount <span class="text-danger">*</span>
                                        </label>
                                        <div class="input-group">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text">$</span>
                                            </div>
                                            <input type="number" class="form-control <?php $__errorArgs = ['total_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                   name="total_amount" id="total_amount" step="0.01" min="0"
                                                   value="<?php echo e(old('total_amount', $booking->total_amount)); ?>" readonly>
                                            <?php $__errorArgs = ['total_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <small class="form-text text-muted">Auto-calculated from booking fee + service fee</small>
                                    </div>

                                    <div class="form-group">
                                        <label for="payment_method" class="form-label font-weight-bold">
                                            Payment Method
                                        </label>
                                        <select class="form-control <?php $__errorArgs = ['payment_method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="payment_method" id="payment_method">
                                            <option value="">Select Payment Method</option>
                                            <option value="Bitcoin" <?php echo e(old('payment_method', $booking->payment_method) == 'Bitcoin' ? 'selected' : ''); ?>>Bitcoin</option>
                                            <option value="Bank Transfer" <?php echo e(old('payment_method', $booking->payment_method) == 'Bank Transfer' ? 'selected' : ''); ?>>Bank Transfer</option>
                                            <option value="PayPal" <?php echo e(old('payment_method', $booking->payment_method) == 'PayPal' ? 'selected' : ''); ?>>PayPal</option>
                                            <option value="Stripe" <?php echo e(old('payment_method', $booking->payment_method) == 'Stripe' ? 'selected' : ''); ?>>Stripe</option>
                                            <option value="Cash" <?php echo e(old('payment_method', $booking->payment_method) == 'Cash' ? 'selected' : ''); ?>>Cash</option>
                                            <option value="Other" <?php echo e(old('payment_method', $booking->payment_method) == 'Other' ? 'selected' : ''); ?>>Other</option>
                                        </select>
                                        <?php $__errorArgs = ['payment_method'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="form-group">
                                        <label for="payment_status" class="form-label font-weight-bold">
                                            Payment Status <span class="text-danger">*</span>
                                        </label>
                                        <select class="form-control <?php $__errorArgs = ['payment_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                name="payment_status" id="payment_status" required>
                                            <option value="pending" <?php echo e(old('payment_status', $booking->payment_status) == 'pending' ? 'selected' : ''); ?>>Pending</option>
                                            <option value="paid" <?php echo e(old('payment_status', $booking->payment_status) == 'paid' ? 'selected' : ''); ?>>Paid</option>
                                            <option value="refunded" <?php echo e(old('payment_status', $booking->payment_status) == 'refunded' ? 'selected' : ''); ?>>Refunded</option>
                                            <option value="cancelled" <?php echo e(old('payment_status', $booking->payment_status) == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                                        </select>
                                        <?php $__errorArgs = ['payment_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <?php if($booking->payment_date): ?>
                                    <div class="form-group">
                                        <label class="form-label font-weight-bold">
                                            Payment Date
                                        </label>
                                        <input type="text" class="form-control"
                                               value="<?php echo e($booking->payment_date->format('M j, Y g:i A')); ?>" readonly>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <!-- Status & Notes -->
                            <div class="card shadow mb-4">
                                <div class="card-header py-3">
                                    <h6 class="m-0 font-weight-bold text-primary">
                                        <i class="fas fa-flag"></i> Status & Notes
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="form-group">
                                        <label for="booking_status" class="form-label font-weight-bold">
                                            Booking Status <span class="text-danger">*</span>
                                        </label>
                                        <select class="form-control <?php $__errorArgs = ['booking_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                name="booking_status" id="booking_status" required>
                                            <option value="pending" <?php echo e(old('booking_status', $booking->booking_status) == 'pending' ? 'selected' : ''); ?>>Pending</option>
                                            <option value="approved" <?php echo e(old('booking_status', $booking->booking_status) == 'approved' ? 'selected' : ''); ?>>Approved</option>
                                            <option value="rejected" <?php echo e(old('booking_status', $booking->booking_status) == 'rejected' ? 'selected' : ''); ?>>Rejected</option>
                                            <option value="completed" <?php echo e(old('booking_status', $booking->booking_status) == 'completed' ? 'selected' : ''); ?>>Completed</option>
                                            <option value="cancelled" <?php echo e(old('booking_status', $booking->booking_status) == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                                        </select>
                                        <?php $__errorArgs = ['booking_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="form-group">
                                        <label for="admin_notes" class="form-label font-weight-bold">
                                            Admin Notes
                                        </label>
                                        <textarea class="form-control <?php $__errorArgs = ['admin_notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                  name="admin_notes" id="admin_notes" rows="5"><?php echo e(old('admin_notes', $booking->admin_notes)); ?></textarea>
                                        <small class="form-text text-muted">Add new notes here. Previous notes will be preserved.</small>
                                        <?php $__errorArgs = ['admin_notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <?php if($booking->cancellation_reason): ?>
                                    <div class="form-group">
                                        <label class="form-label font-weight-bold">
                                            Cancellation Reason
                                        </label>
                                        <div class="alert alert-warning">
                                            <?php echo e($booking->cancellation_reason); ?>

                                        </div>
                                    </div>
                                    <?php endif; ?>

                                    <div class="form-group">
                                        <label class="form-label font-weight-bold">
                                            Last Updated
                                        </label>
                                        <input type="text" class="form-control"
                                               value="<?php echo e($booking->updated_at->format('M j, Y g:i A')); ?>" readonly>
                                    </div>
                                </div>
                            </div>

                            <!-- Quick Actions -->
                            <div class="card shadow mb-4">
                                <div class="card-header py-3">
                                    <h6 class="m-0 font-weight-bold text-primary">
                                        <i class="fas fa-bolt"></i> Quick Actions
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="row mb-3">
                                        <div class="col-12">
                                            <button type="button" class="btn btn-block btn-outline-primary" onclick="previewChanges()">
                                                <i class="fas fa-eye"></i> Preview Changes
                                            </button>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <div class="col-12">
                                            <button type="submit" class="btn btn-block btn-success">
                                                <i class="fas fa-save"></i> Save Changes
                                            </button>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <div class="col-12">
                                            <button type="button" class="btn btn-block btn-warning" onclick="resetForm()">
                                                <i class="fas fa-undo"></i> Reset Form
                                            </button>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-12">
                                            <a href="<?php echo e(route('admin.bookings.show', $booking->id)); ?>" class="btn btn-block btn-outline-info">
                                                <i class="fas fa-eye"></i> View Details
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

<!-- Preview Changes Modal -->
<div class="modal fade" id="previewModal" tabindex="-1" role="dialog" aria-labelledby="previewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="previewModalLabel">
                    <i class="fas fa-eye"></i> Preview Changes
                </h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div id="previewContent">
                    <!-- Preview content will be populated by JavaScript -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-success" onclick="$('#previewModal').modal('hide'); $('form').submit();">
                    <i class="fas fa-save"></i> Confirm & Save
                </button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
$(document).ready(function() {
    // Initialize Select2
    $('.select2').select2({
        placeholder: 'Select Celebrity',
        width: '100%'
    });

    // Auto-calculate total amount
    $('#booking_fee, #service_fee').on('input change', function() {
        calculateTotal();
    });

    // Form validation
    $('form').on('submit', function(e) {
        if (!this.checkValidity()) {
            e.preventDefault();
            e.stopPropagation();
        }
        $(this).addClass('was-validated');
    });

    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
});

// Calculate total amount
function calculateTotal() {
    const bookingFee = parseFloat($('#booking_fee').val()) || 0;
    const serviceFee = parseFloat($('#service_fee').val()) || 0;
    const totalAmount = bookingFee + serviceFee;

    $('#total_amount').val(totalAmount.toFixed(2));
}

// Print booking form
function printBooking() {
    window.print();
}

// Preview changes
function previewChanges() {
    const formData = new FormData($('form')[0]);
    let previewContent = '<div class="row">';

    // Customer Info
    previewContent += '<div class="col-md-6"><h6 class="font-weight-bold text-primary border-bottom pb-2">Customer Information</h6>';
    previewContent += '<p><strong><i class="fas fa-user text-primary"></i> Name:</strong> ' + formData.get('full_name') + '</p>';
    previewContent += '<p><strong><i class="fas fa-envelope text-info"></i> Email:</strong> ' + formData.get('email') + '</p>';
    previewContent += '<p><strong><i class="fas fa-phone text-success"></i> Phone:</strong> ' + formData.get('phone') + '</p>';
    previewContent += '<p><strong><i class="fas fa-venus-mars text-secondary"></i> Gender:</strong> ' + (formData.get('gender') || 'Not specified') + '</p>';
    if (formData.get('address')) {
        previewContent += '<p><strong><i class="fas fa-map-marker-alt text-warning"></i> Address:</strong> ' + formData.get('address') + '</p>';
    }
    previewContent += '</div>';

    // Event Info
    previewContent += '<div class="col-md-6"><h6 class="font-weight-bold text-success border-bottom pb-2">Event Information</h6>';
    previewContent += '<p><strong><i class="fas fa-clipboard-list text-primary"></i> Event Type:</strong> ' + formData.get('event_type') + '</p>';
    previewContent += '<p><strong><i class="fas fa-map-pin text-danger"></i> Location:</strong> ' + formData.get('event_location') + '</p>';
    previewContent += '<p><strong><i class="fas fa-calendar text-info"></i> Date:</strong> ' + formData.get('event_date') + '</p>';
    previewContent += '<p><strong><i class="fas fa-clock text-warning"></i> Time:</strong> ' + formData.get('event_time') + '</p>';
    previewContent += '<p><strong><i class="fas fa-hourglass-half text-secondary"></i> Duration:</strong> ' + formData.get('duration') + ' minutes</p>';
    previewContent += '</div>';

    previewContent += '</div><hr><div class="row">';

    // Payment Info
    previewContent += '<div class="col-md-6"><h6 class="font-weight-bold text-warning border-bottom pb-2">Payment Information</h6>';
    previewContent += '<p><strong>Booking Fee:</strong> $' + parseFloat(formData.get('booking_fee')).toFixed(2) + '</p>';
    previewContent += '<p><strong>Service Fee:</strong> $' + parseFloat(formData.get('service_fee')).toFixed(2) + '</p>';
    previewContent += '<p><strong>Total Amount:</strong> <span class="text-success">$' + parseFloat(formData.get('total_amount')).toFixed(2) + '</span></p>';
    previewContent += '<p><strong>Payment Status:</strong> <span class="badge badge-' +
        (formData.get('payment_status') == 'paid' ? 'success' :
         formData.get('payment_status') == 'pending' ? 'warning' : 'danger') + '">' +
        formData.get('payment_status') + '</span></p>';
    if (formData.get('payment_method')) {
        previewContent += '<p><strong>Payment Method:</strong> ' + formData.get('payment_method') + '</p>';
    }
    previewContent += '</div>';

    // Status Info
    previewContent += '<div class="col-md-6"><h6 class="font-weight-bold text-info border-bottom pb-2">Status Information</h6>';
    previewContent += '<p><strong>Booking Status:</strong> <span class="badge badge-' +
        (formData.get('booking_status') == 'completed' ? 'success' :
         formData.get('booking_status') == 'approved' ? 'primary' :
         formData.get('booking_status') == 'pending' ? 'warning' : 'danger') + '">' +
        formData.get('booking_status') + '</span></p>';
    if (formData.get('admin_notes')) {
        previewContent += '<p><strong>Admin Notes:</strong></p><div class="bg-light p-2 rounded small">' + formData.get('admin_notes').replace(/\n/g, '<br>') + '</div>';
    }
    previewContent += '</div>';

    previewContent += '</div>';

    $('#previewContent').html(previewContent);
    $('#previewModal').modal('show');
}

// Reset form
function resetForm() {
    if (confirm('Are you sure you want to reset all changes? This will reload the original data.')) {
        location.reload();
    }
}

// Status change warnings
$('#booking_status').on('change', function() {
    const status = $(this).val();
    const warnings = {
        'rejected': 'This will reject the booking and notify the customer.',
        'cancelled': 'This will cancel the booking and may trigger refund processes.',
        'completed': 'This will mark the booking as completed and finalize the transaction.'
    };

    $('.status-warning').remove();
    if (warnings[status]) {
        $(this).after('<small class="text-warning mt-1 d-block status-warning"><i class="fas fa-exclamation-triangle"></i> ' + warnings[status] + '</small>');
    }
});

// Payment status change warnings
$('#payment_status').on('change', function() {
    const status = $(this).val();
    const warnings = {
        'paid': 'This will mark the payment as received.',
        'refunded': 'This indicates the payment has been refunded to the customer.',
        'cancelled': 'This will mark the payment as cancelled.'
    };

    $('.payment-warning').remove();
    if (warnings[status]) {
        $(this).after('<small class="text-info mt-1 d-block payment-warning"><i class="fas fa-info-circle"></i> ' + warnings[status] + '</small>');
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app1', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\celeb\resources\views/admin/celebrity/edit.blade.php ENDPATH**/ ?>